////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_COMMON_H
#define BK_COMMON_H

#define SAFE_RELEASE(x) if (x) { x->Release(); x = NULL;}

#if !defined(PRINTF)
    #if defined(UTF8_ENCODING)
        #define PRINTF(...) printf(__VA_ARGS__)
    #else
        #define PRINTF(...) wprintf(__VA_ARGS__)
    #endif
#endif

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "GTypes.h"

#include "Length.h"
#include "PProfiler.h"
#include "PString.h"
#include "WString.h"
#include "AList.h"
#include "PConsole.h"

#include "PAtomic.h"
#include "PLock.h"
#include "PTime.h"
#include "PFileSystem.h"
#include "PShared.h"
#include "UTF.h"
#include "IFile.h"
#include "PFile.h"
#include "Lock.h"
#include "IMEvent.h"
#include "PMEvent.h"
#include "PThreadShell.h"
#include "PProcess.h"

#include "IJournal.h"

#include "PSocket.h"

#include "Prop.h"

#include "P7_Client.h"
#include "P7_Trace.h"
#include "P7_Telemetry.h"
#include "P7_Extensions.h"

#include "PAPI.h"
#include "PAPI_Node.h"
#include "PAPI_Plugins.h"
#include "PAPI_Provider.h"
#include "PAPI_Dispatcher.h"
#include "PAPI_Storage.h"
#include "PAPI_Processor.h"
#include "PAPI_Viewer.h"
#include "PAPI_Core.h"
#include "PAPI_Storage_Telemetry.h"
#include "PAPI_Storage_Trace.h"
#include "IBDoc.h"
#include "Plugins.h"
#include "BaicalXML.h"
#include "Streams.h"
#include "XmlMerge.h"
#include "Baical.h"

#include "CContext.h"

#if defined(_WIN32) || defined(_WIN64)
    #pragma warning(disable : 4995)
    #pragma warning(disable : 4996)
    #pragma warning(disable : 4091)
    #include "Shellapi.h"
    #include "Shlobj.h"
#endif


#endif //BK_COMMON_H
