////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_CONTEXT_H
#define BK_CONTEXT_H

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class CContext
{
public:
    enum eMenus
    {
        eMenuMain = 0,
        eMenuStreams,
        eMenuOpen,

        eMenuMax
    };

    struct stStream
    {
        Bk::IStorageReader *pReader;
        Bk::IStreamEx      *pExtra;

        stStream(Bk::IStorageReader *i_pStream, Bk::IStreamEx *i_pExtra) : pReader(i_pStream), pExtra(i_pExtra) {}
        ~stStream() { SAFE_RELEASE(pReader); SAFE_RELEASE(pExtra); }
    };

    CConsole          m_cCon;
    CBaical          *m_pBaical;
    Bk::IStreams     *m_iSubscriber;
    CBList<stStream*> m_cStreams;
    pAList_Cell       m_pElActiveStream;
    size_t            m_szNewStreams;
    tBOOL             m_bError;
    CConsoleWnd      *m_pMenus[eMenuMax];
    CConsoleWnd      *m_pMenu;
    tUINT32           m_uiUpdateIntervalMs;
    tUINT32           m_uiUpdateTimeStamp;
    tBOOL             m_bExit;


    CContext(const tXCHAR *i_pConfigPath);
    virtual ~CContext();
    int Execute();
    void AddStream(Bk::IStorageReader *i_pReader, Bk::IStreamEx *i_pExtra);
};


#endif //BK_CONTEXT_H