////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_MENUMAIN_H
#define BK_MENUMAIN_H

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class CMenuMain
    : public CConsoleWnd
{
    CContext     *m_pContext;
    const tXCHAR *m_pMenus[2];

public:
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    CMenuMain(CContext *i_pContext)
        : CConsoleWnd()  
        , m_pContext(i_pContext)
    {
        m_pMenus[0] = TM(" * Streams list");
        m_pMenus[1] = TM(" * Open stream(s) folder");

        CConsoleWnd::sCfg l_cCfg = {};

        l_cCfg.pConsole      = &m_pContext->m_cCon;
        l_cCfg.szItemsCount  = LENGTH(m_pMenus);
        l_cCfg.uX            = 0;
        l_cCfg.uY            = 0;
        l_cCfg.uH            = m_pContext->m_cCon.GetHeight() - 1;
        l_cCfg.uW            = m_pContext->m_cCon.GetWidth();
        l_cCfg.pCaption      = TM("Baical");
        l_cCfg.eWindowBgColor= IConsole::eBlack;
        l_cCfg.eItemBgColor  = IConsole::eBlack;
        l_cCfg.eItemFgColor  = IConsole::eGreen;
        l_cCfg.eItemSlFgColor= IConsole::eBlue;
        l_cCfg.eItemSlBgColor= IConsole::eWhite;
        l_cCfg.uLinesPerItem = 1;

        CConsoleWnd::Init(l_cCfg);
    }             

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    virtual size_t Print()
    {
        size_t l_szCount = 0;

        if (m_bHelp)
        {
            return m_uH;
        }

        while (    (l_szCount < m_szItemsPerWnd)
                && ((tUINT64)l_szCount < m_qwItemsCount)
              )
        {
            if (l_szCount == m_szOffsetY)
            {
                m_pContext->m_cCon.WriteText(m_eItemSlFgColor, m_eItemSlBgColor, m_uW, m_uW, m_pMenus[m_qwOffsetWnd + l_szCount]);
            }
            else
            {
                m_pContext->m_cCon.WriteText(m_eItemFgColor, m_eItemBgColor, m_uW, m_uW, m_pMenus[m_qwOffsetWnd + l_szCount]);
            }

            l_szCount ++;
        }

        return l_szCount;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    virtual tBOOL ProcessKey(tUINT16 i_xChar)
    {
        if (m_bError)
        {
            return FALSE;
        }

        if (m_bHelp)
        {
            return CConsoleWnd::ProcessKey(i_xChar);
        }

        tBOOL l_bReturn = FALSE;

        if ((tUINT16)IConsole::eKeyEnter == i_xChar)
        {
            tUINT64 l_qwIndex = m_qwOffsetWnd + m_szOffsetY;
            if (0 == l_qwIndex) //streams list
            {
                m_pContext->m_uiUpdateIntervalMs = 1;
                m_pContext->m_uiUpdateTimeStamp  = GetTickCount();
                m_pContext->m_pMenu              = m_pContext->m_pMenus[CContext::eMenuStreams];
            }
            else if (1 == l_qwIndex) //open stream folder
            {
                m_pContext->m_uiUpdateIntervalMs = 1;
                m_pContext->m_uiUpdateTimeStamp  = GetTickCount();
                m_pContext->m_pMenu              = m_pContext->m_pMenus[CContext::eMenuOpen];
            }

            l_bReturn = TRUE;
        }
        else if ((tUINT16)IConsole::eKeyEsc == i_xChar)
        {
            m_pContext->m_bExit = TRUE;
            l_bReturn           = TRUE;
        }
        else
        {
            l_bReturn = CConsoleWnd::ProcessKey(i_xChar);
        }

        return l_bReturn;
    }

};


#endif //BK_MENUMAIN_H
