////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_MENUOPEN_H
#define BK_MENUOPEN_H

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class CMenuOpen
    : public CConsoleWnd
{
    CContext          *m_pContext;
    CWString           m_cCurrent;
    CBList<CWString*>  m_cDirs;

public:
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    CMenuOpen(CContext *i_pContext)
        : CConsoleWnd()  
        , m_pContext(i_pContext)
    {
        CConsoleWnd::sCfg l_cCfg = {};

        CFSYS::GetUserDirectory(&m_cCurrent);
        CFSYS::Enumerate_Dirs(&m_cDirs, m_cCurrent.Get());


        l_cCfg.pConsole      = &m_pContext->m_cCon;
        l_cCfg.szItemsCount  = m_cDirs.Count();
        l_cCfg.uX            = 0;
        l_cCfg.uY            = 0;
        l_cCfg.uH            = m_pContext->m_cCon.GetHeight() - 1;
        l_cCfg.uW            = m_pContext->m_cCon.GetWidth();
        l_cCfg.pCaption      = m_cCurrent.Get();
        l_cCfg.eWindowBgColor= IConsole::eBlack;
        l_cCfg.eItemBgColor  = IConsole::eBlack;
        l_cCfg.eItemFgColor  = IConsole::eGreen;
        l_cCfg.eItemSlFgColor= IConsole::eBlue;
        l_cCfg.eItemSlBgColor= IConsole::eWhite;
        l_cCfg.uLinesPerItem = 1;

        CConsoleWnd::Init(l_cCfg);

        CConsoleWnd::PushHelpString(TM(" * Enter - level down"), IConsole::eBlack, IConsole::eWhite);
        CConsoleWnd::PushHelpString(TM(" * F12 - level up"), IConsole::eBlack, IConsole::eWhite);
        CConsoleWnd::PushHelpString(TM(" * Space - select directory & close"), IConsole::eBlack, IConsole::eLightGreen);
    }        

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    virtual ~CMenuOpen()
    {
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    virtual size_t Print()
    {
        size_t l_szCount = 0;

        if (m_bHelp)
        {
            return m_uH;
        }

        while (    (l_szCount < m_szItemsPerWnd)
                && ((tUINT64)l_szCount < m_qwItemsCount)
              )
        {
            tXCHAR *l_pName = m_cDirs[(tUINT32)m_qwOffsetWnd + (tUINT32)l_szCount]->Get();

            if (m_cCurrent.Length())
            {
                tXCHAR *l_pTemp = PStrrChr(l_pName, TM('\\'));

                if (!l_pTemp)
                {
                    l_pTemp = PStrrChr(l_pName, TM('/'));
                }

                if (l_pTemp)
                {
                    l_pName = l_pTemp + 1;
                }
            }

            if (l_szCount == m_szOffsetY)
            {
                m_pContext->m_cCon.WriteTextO(m_eItemSlFgColor, m_eItemSlBgColor, m_uW, m_uW, m_szOffsetX, TM(" {%s}"), l_pName);
            }
            else
            {
                m_pContext->m_cCon.WriteTextO(m_eItemFgColor, m_eItemBgColor, m_uW, m_uW, m_szOffsetX, TM(" {%s}"), l_pName);
            }

            l_szCount ++;
        }

        return l_szCount;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    virtual tBOOL ProcessKey(tUINT16 i_xChar)
    {
        if (m_bError)
        {
            return FALSE;
        }

        if (m_bHelp)
        {
            return CConsoleWnd::ProcessKey(i_xChar);
        }

        tBOOL l_bReturn = FALSE;

        if ((tUINT16)IConsole::eKeyEnter == i_xChar)
        {
            tUINT64 l_qwIndex = m_qwOffsetWnd + m_szOffsetY;

            m_cCurrent.Set(m_cDirs[(tUINT32)l_qwIndex]->Get());

            this->SetCaption(m_cCurrent.Get());

            m_cDirs.Clear(TRUE);
            CFSYS::Enumerate_Dirs(&m_cDirs, m_cCurrent.Get());

            this->SetItemsCount(m_cDirs.Count());

            m_szOffsetY = 0;
            m_qwOffsetWnd = 0;

            m_pContext->m_uiUpdateIntervalMs = 1;
            m_pContext->m_uiUpdateTimeStamp  = GetTickCount();

            l_bReturn = TRUE;
        }
        else if ((tUINT16)IConsole::eKeyF12 == i_xChar)
        {
            CWString l_cParent;

            if (CFSYS::GetDirectoryParent(m_cCurrent, l_cParent))
            {
                m_cCurrent.Set(l_cParent.Get());
                this->SetCaption(m_cCurrent.Get());

                m_cDirs.Clear(TRUE);
                CFSYS::Enumerate_Dirs(&m_cDirs, m_cCurrent.Get());

                this->SetItemsCount(m_cDirs.Count());

                m_szOffsetY = 0;
                m_qwOffsetWnd = 0;

                m_pContext->m_uiUpdateIntervalMs = 1;
                m_pContext->m_uiUpdateTimeStamp  = GetTickCount();
            }

            l_bReturn = TRUE;
        }
        else if ((tUINT16)IConsole::eKeySpace == i_xChar)
        {
            tUINT64   l_qwIndex = m_qwOffsetWnd + m_szOffsetY;
            CWString *l_pDir    = m_cDirs[(tUINT32)l_qwIndex];
            if (l_pDir)
            {
                pAList_Cell       l_pEl = NULL;  
                CBList<CWString*> l_cFiles;

                CFSYS::Enumerate_Files(&l_cFiles, l_pDir, TM("*.*"));

                while ((l_pEl = l_cFiles.Get_Next(l_pEl)))
                {
                    CWString           *l_pFile   = l_cFiles.Get_Data(l_pEl);
                    Bk::IStorageReader *l_pReader = NULL;
                    Bk::eResult         l_eResult = m_pContext->m_pBaical->Open_Storage(0, &l_pReader, l_pFile->Get());

                    if (Bk::eOk == l_eResult)
                    {
                        m_pContext->AddStream(l_pReader, NULL);
                    }
                }

                l_cFiles.Clear(TRUE);

                m_pContext->m_pMenu              = m_pContext->m_pMenus[CContext::eMenuMain];
                m_pContext->m_uiUpdateIntervalMs = 1;
                m_pContext->m_uiUpdateTimeStamp  = GetTickCount();
            }

            l_bReturn = TRUE;
        }
        else if ((tUINT16)IConsole::eKeyEsc == i_xChar)
        {
            m_pContext->m_pMenu              = m_pContext->m_pMenus[CContext::eMenuMain];
            m_pContext->m_uiUpdateIntervalMs = 1;
            m_pContext->m_uiUpdateTimeStamp  = GetTickCount();
            l_bReturn                        = TRUE;
        }
        else
        {
            l_bReturn = CConsoleWnd::ProcessKey(i_xChar);
        }

        return l_bReturn;
    }

};


#endif //BK_MENUOPEN_H
