////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_IDOC_H
#define BK_IDOC_H

class IBDoc
{
public:
    virtual tBOOL       Get_Initialized() = 0;
    virtual Bk::eResult Save() = 0;
    virtual Bk::eResult Save_As(const tXCHAR *i_pFile_Name) = 0;

    virtual Bk::eResult GetChildFirst(Bk::IBNode **o_pIXNode) = 0;
    virtual Bk::eResult GetChildFirst(const tXCHAR  *i_pName, Bk::IBNode **o_pIXNode) = 0;
    virtual Bk::eResult AddChildEmpty(const tXCHAR  *i_pName, Bk::IBNode **o_pIXNode) = 0;
    virtual Bk::eResult DelChild(Bk::IBNode *i_pIXNode) = 0;
    virtual void        Release() = 0;
};

extern "C" P7_EXPORT IBDoc* __cdecl IBDoc_Load(const tXCHAR *i_pFile_Name);
extern "C" P7_EXPORT IBDoc* __cdecl IBDoc_Load_Buffer(const void *i_pBuffer, size_t i_szBuffer);
extern "C" P7_EXPORT IBDoc* __cdecl IBDoc_Create();

#endif //BK_IDOC_H