////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_REMOTE_BASE_H
#define BK_REMOTE_BASE_H

#include "GTypes.h"
#include "Length.h"
#include "PString.h"
#include "WString.h"

#include "PAtomic.h"
#include "PLock.h"
#include "Lock.h"
#include "AList.h"
#include "UTF.h"
#include "Lock.h"
#include "IMEvent.h"
#include "PMEvent.h"
#include "PThreadShell.h"
#include "PSocket.h"
#include "UDP_NB.h"
#include "CRC32.h"

enum eRmCommand
{
    eRmCmdBringToFront = 0, //no data
    eRmCmdOpenFile,         //sRmOpenFile
    eRmCmdExit,             //no data
    eRmCmdPing,             //no data
    eRmCmdAck,              //sRmAck

    //PossibleImprovement:
    //eRmCmdCloseStream,      //sRmStreamId
    //eRmCmdDeleteStream,     //sRmStreamId
    //eRmCmdGetStreams,       //sRmStreams
    eRmCmdCount
};

enum eRmAck
{
    eRmAckOk = 0, //no data
    eRmAckError
};


#define RM_MAX_PACKET_SIZE                                         65535u
#define RM_UDP_PORT                                                9012u

#define RM_FLAG_BIG_ENDIAN                                         (0x001u) // 1 << 0
#define RM_FLAG_CHUNKED                                            (0x002u) // 1 << 1
#define RM_FLAG_LAST_CHUNK                                         (0x004u) // 1 << 2
#define RM_FLAG_NO_CRC                                             (0x008u) // 1 << 3
#define RM_FLAG_RESERVED_04                                        (0x010u) // 1 << 4
#define RM_FLAG_RESERVED_05                                        (0x020u) // 1 << 5
#define RM_FLAG_RESERVED_06                                        (0x040u) // 1 << 6
#define RM_FLAG_RESERVED_07                                        (0x080u) // 1 << 7
#define RM_FLAG_RESERVED_08                                        (0x100u) // 1 << 8
#define RM_FLAG_RESERVED_09                                        (0x200u) // 1 << 9
#define RM_FLAG_RESERVED_10                                        (0x400u) // 1 << 10


PRAGMA_PACK_ENTER(4) //alignment is now 4, MS only !

struct sRmCommon
{
    tUINT32     uiCrc32;
    eRmCommand  eCmd;
    tUINT32     uiFlags;
    tUINT32     uiSize; 
} ATTR_PACK(4);

struct sRmOpenFile
{
    sRmCommon stHdr;
    char      pUtf8Name[4]; 
} ATTR_PACK(4);

struct sRmAck
{
    sRmCommon stHdr;
    eRmAck    eCode;
} ATTR_PACK(4);

// struct sRmStreamId
// {
//     sRmCommon stHdr;
//     tUINT64   qwStreamId;
// } ATTR_PACK(4);
// 
// struct sRmStreams
// {
//     sRmCommon stHdr;
//     tUINT64   qwStreamsId[1];
// } ATTR_PACK(4);           

PRAGMA_PACK_EXIT()


#endif //BK_REMOTE_BASE_H
