////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef P7_SERVER_IMP_H
#define P7_SERVER_IMP_H

#define P7_SERVER_DEFAULT_PORT                                              9009
#define P7_PROP_ENABLE                                                  TM("Enable")
#define P7_PROP_PORT                                                    TM("Port")

class CServer: 
     public IP7_Server
{
    //put volatile variables at the top, to obtain 32 bit alignment. 
    //Project has 8 bytes alignment by default
    tINT32 volatile       m_lReference;

    IJournal             *m_pLog;
    IJournal::hModule     m_hLogMod;
    CBuffers_Pools       *m_pBPool;
    CBList<CSAddress*>   *m_pAddresses;
    eServer_Status        m_eStatus;
    tBOOL                 m_bIs_Winsock;

public:
    CServer(IJournal *i_pLog, CProperty *i_pProp);
    virtual ~CServer();

    IP7S_Address  *Get_Next_Address(IP7S_Address *i_pAddress);
    eServer_Status Get_Status();

    void           Get_MemStat(size_t &o_rBusy, size_t &o_rAllocated);

    virtual tINT32 Add_Ref()
    {
        return ATOMIC_INC(&m_lReference);
    }

    virtual tINT32 Release()
    {
        tINT32 l_lResult = ATOMIC_DEC(&m_lReference);
        if ( 0 >= l_lResult )
        {
            delete this;
        }

        return l_lResult;
    }

private:
    tUINT32 Create_Addresses(CBList<sockaddr_storage*> *io_pList, CProperty *i_pProp);

};

#endif //P7_SERVER_IMP_H
