////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////


void CThread::Print_Packet(WCHAR * i_pPrefix,  CLFTransportPacket * i_pPacket)
{
    if ( (NULL == i_pPacket) || (NULL == m_pConsole) )
    {
        return;
    }

    WCHAR * l_pPrefix = i_pPrefix ? i_pPrefix : L"ELOG SRV:";

    if (LF_CLIENT_PACKET_INITIAL == i_pPacket->GetPacketType())
    {
         CLFClientInitialPacket l_cInitial(i_pPacket, ELF_TP_SHELL_LINK);
         m_pConsole->Print(L"%s %s [CLIENT INITIAL] Packet ID = %d, Size = %d. Name=%s, Version=%s\n", 
                           l_pPrefix, 
                           m_pConsole->Get_Time(),
                           (DWORD)l_cInitial.GetID(),
                           (DWORD)l_cInitial.GetPacketSize(),
                           (WCHAR*)l_cInitial.GetDeviceName(),
                           (WCHAR*)l_cInitial.GetDeviceVersion()
                           );
    }
    else if (LF_CLIENT_PACKET_ALIVE == i_pPacket->GetPacketType())
    {
        CLFClientAlivePacket l_cAlive(i_pPacket, ELF_TP_SHELL_LINK);
        m_pConsole->Print(L"%s %s [CLIENT ALIVE] Packet ID = %d, Size = %d\n", 
                          l_pPrefix, 
                          m_pConsole->Get_Time(),
                          (DWORD)l_cAlive.GetID(),
                          (DWORD)l_cAlive.GetPacketSize()
                         );
    }
    else if (LF_CLIENT_PACKET_DATA_REPORT == i_pPacket->GetPacketType())
    {
        CLFClientReportPacket l_cClientReport(i_pPacket, ELF_TP_SHELL_LINK);
        m_pConsole->Print(L"%s %s [CLIENT REPORT] Packet ID = %d, Size = %d. ID Interval = [%d .. %d]\n", 
                          l_pPrefix, 
                          m_pConsole->Get_Time(),
                          (DWORD)l_cClientReport.GetID(),
                          (DWORD)l_cClientReport.GetPacketSize(),
                          (DWORD)l_cClientReport.GetStartID(),
                          (DWORD)l_cClientReport.GetFinishID()
                         );
    }
    else if (LF_SERVER_PACKET_RESPONSE == i_pPacket->GetPacketType())
    {
        CLFServerResponsePacket l_cServer_Response(i_pPacket, ELF_TP_SHELL_LINK);
        m_pConsole->Print(L"%s %s [SERVER RESPONSE] Packet ID = %d (Source ID = %d), Size = %d. Result = %d\n", 
                          l_pPrefix, 
                          m_pConsole->Get_Time(),
                          (DWORD)l_cServer_Response.GetID(),
                          (DWORD)l_cServer_Response.GetSourceID(),
                          (DWORD)l_cServer_Response.GetPacketSize(),
                          (DWORD)l_cServer_Response.GetResult()
                         );
    }
    else if (LF_SERVER_PACKET_DATA_REPORT == i_pPacket->GetPacketType())
    {
        CLFServerReportPacket l_cServer_Report(i_pPacket, ELF_TP_SHELL_LINK);
        m_pConsole->Print(L"%s %s [SERVER DATA REPORT] Packet ID = %d (Source ID = %d), Size = %d, Packets Missed:\n", 
                          l_pPrefix, 
                          m_pConsole->Get_Time(),
                          (DWORD)l_cServer_Report.GetID(),
                          (DWORD)l_cServer_Report.GetSourceID(),
                          (DWORD)l_cServer_Report.GetPacketSize()
                         );

        DWORD l_dwIDX = 0;
        for (l_dwIDX = 0; l_dwIDX < (LF_TP_TRANSPORT_PACKET_SIZE - ELF_SERVER_REPORT_PACKET_HEADER_SIZE - 1) * 8; l_dwIDX++)
        {
            if (l_cServer_Report.CheckID(0, l_dwIDX))
            {
                m_pConsole->Print(L"%d, ", l_dwIDX);
            }
        }
        m_pConsole->Print(L"\n");
    }
    else if (LF_CLIENT_PACKET_BYE == i_pPacket->GetPacketType())
    {
        CLFClientByePacket l_cClient_Bye(i_pPacket, ELF_TP_SHELL_LINK);
        m_pConsole->Print(L"%s %s [CLIENT BYE] Packet ID = %d, Size = %d\n", 
                          l_pPrefix, 
                          m_pConsole->Get_Time(),
                          (DWORD)l_cClient_Bye.GetID(),
                          (DWORD)l_cClient_Bye.GetPacketSize()
                         );
    }


}
