////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_API_DISPATCHER_H
#define BK_API_DISPATCHER_H

#include "PAPI.h"
#include "PAPI_Node.h"
#include "PAPI_Provider.h"

namespace Bk
{
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// <summary> Plugin interface </summary>
    class IDispatcher
        : public virtual Bk::IUnknown
    {
    public:
        /// <summary> 
        /// Asks plugin to initialize it self, query interfaces, etc. Trying to query external interfaces on creation may not work due to
        /// unexpected order of initialization of different plugins, so this function is right place to query interfaces
        /// </summary>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        virtual Bk::eResult __stdcall Initialize() = 0;

        /// <summary> Find appropriate storage plugin using incoming stream GUID </summary>
        /// <param name="i_rStreamInfo"> stream info </param>
        /// <returns> Plugin interface </returns>  
        virtual Bk::IPlugin* __stdcall Dispatch(const Bk::stStreamInfo &i_rStreamInfo) = 0;

        /// <summary>
        /// Get dispatcher priority, used by Baical core to sort dispatchers plugins.
        /// Plugin with highest priority will be called first, if such plugin will fail - next plugin in the list will be called
        /// </summary>
        /// <returns> priority value, 0 - lowest, 255 - highest </returns>  
        virtual tUINT8 __stdcall GetPriority() = 0;
    };
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////// Plugins function prototypes /////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/// <summary> create dispatcher function prototype </summary>
#define BK_CREATE_DISPATCHER "Create_Dispatcher"
typedef Bk::eResult (__cdecl *fnBkCreateDispatcher)(Bk::IUnknown     *i_pBaikal,     //[inp] Baikal interface
                                                    Bk::IBNode       *i_pNode,       //[inp] Dispatcher config. node
                                                    CProperty        *i_pProp,       //[Inp] properties
                                                    Bk::IDispatcher *&o_rDispatcher  //[out] Dispatcher interface
                                                   );
#endif //BK_API_DISPATCHER_H