////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_API_PROCESSOR_H
#define BK_API_PROCESSOR_H

#include "PAPI.h"
#include "PAPI_Node.h"
#include "PAPI_Provider.h"
#include "PAPI_Storage.h"

namespace Bk
{
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// <summary> New streams interface </summary>
    class IStreams
        : public virtual Bk::IUnknown
    {
    public:
        /// <summary> Pulls new stream from the list </summary>
        /// <param name="o_rReader"> Stream reader interface, output value, please do not forget to release interface </param>
        /// <param name="o_rExtra"> Stream extra interface, output value, please do not forget to release interface </param>
        /// <param name="i_uiTimeout"> timeout in milliseconds </param>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        virtual Bk::eResult __stdcall Pull(Bk::IStorageReader *&o_rReader, Bk::IStreamEx *&o_rExtra, tUINT32 i_uiTimeout) = 0;
    };

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// <summary> Streams processor interface </summary>
    class IProcessor
        : public virtual Bk::IUnknown
    {
    public:
        /// <summary> 
        /// Asks plugin to initialize it self, query interfaces, etc. Trying to query external interfaces on creation may not work due to
        /// unexpected order of initialization of different plugins, so this function is right place to query interfaces
        /// </summary>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        virtual Bk::eResult __stdcall Initialize() = 0;
    };
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////// Plugins function prototypes ////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/// <summary> create processor function prototype </summary>
#define BK_CREATE_PROCESSOR "Create_Processor"
typedef Bk::eResult (__cdecl *fnBkCreateProcessor)(Bk::IUnknown    *i_pBaikal,     //[inp] Baikal interface
                                                   Bk::IBNode      *i_pNode,       //[inp] Processor config. node
                                                   CProperty       *i_pProp,       //[Inp] properties
                                                   Bk::IProcessor *&o_rProcessor   //[out] Processor interface
                                                  );
#endif //BK_API_PROCESSOR_H