////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_API_VIEWER_H
#define BK_API_VIEWER_H

#include "PAPI.h"
#include "PAPI_Node.h"
#include "PAPI_Storage.h"
#include "PAPI_Provider.h"
#include "Prop.h"

namespace Bk
{
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// <summary> Viewer plugin interface </summary>
    class IViewer
    {
    public:
        /// <summary> Shows viewer window </summary>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        virtual Bk::eResult __stdcall Show()  = 0;

        /// <summary> Closes viewer window </summary>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        virtual Bk::eResult __stdcall Close()  = 0;

        /// <summary> Get window title </summary>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        //virtual Bk::eResult __stdcall Get_Title(tXCHAR *i_pTitle, size_t i_szTitle)  = 0;
        
        /// <summary> Set position </summary>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        virtual Bk::eResult __stdcall Set_Position(Bk::IViewer *i_pSrc,
                                                   tUINT32      i_uiYear,
                                                   tUINT32      i_uiMonth,
                                                   tUINT32      i_uiDay,
                                                   tUINT32      i_uiHour,
                                                   tUINT32      i_uiMin,
                                                   tUINT32      i_uiSec,
                                                   tUINT32      i_uiMilsec,
                                                   tUINT32      i_uiMicsec,
                                                   tUINT32      i_uiNansec
                                                  ) = 0;

        /// <summary> Set window visibility </summary>
        /// <param name="i_bVisible"> visibility flag </param>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        virtual Bk::eResult __stdcall Set_Visible(tBOOL i_bVisible) = 0;
                                                                              
        /// <summary> Returns state of the window </summary>
        /// <returns>TRUE - closed, else - FALSE</returns>  
        virtual tBOOL __stdcall Closed() = 0;
                                                                              
        /// <summary> Increases object reference counter </summary>
        /// <returns> new value of reference counter </returns>  
        virtual tINT32 __stdcall Add_Ref() = 0;

        /// <summary> Decreases object reference counter. If 0 - object will be self-destroyed </summary>
        /// <returns> new value of reference counter </returns>  
        virtual tINT32 __stdcall Release() = 0;
    };


    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// <summary> Viewers enumerator interface </summary>
    class IViewersEnumerator
    {
    public:
        /// <summary> Get Viewers count </summary>
        /// <returns> viewers count </returns>  
        virtual tUINT32 __stdcall GetViewersCount() = 0;

        /// <summary> Get viewer by index, do not forget to call Bk::IViewer::Release() </summary>
        /// <returns> viewer </returns>  
        virtual Bk::IViewer* __stdcall GetViewer(tUINT32 i_uiIndex) = 0;
    };
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////// Plugins function prototypes /////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/// <summary> create viewer function prototype </summary>
#define BK_CREATE_VIEWER                                        "Create_Viewer"
typedef Bk::eResult (__cdecl *fnBkCreateViewer)(Bk::IViewer           **o_pViewer,  //[Out] result viewer interface
                                                WND_HANDLE              i_hParent,  //[Inp] parent window
                                                Bk::IBNode             *i_pNode,    //[Inp] stored configuration node
                                                Bk::IStorageReader     *i_iReader,  //[Inp] reader interface
                                                Bk::IStreamEx          *i_iExtra,   //[Inp] stream extra interface, NULL for offline streams
                                                CProperty              *i_pProp,    //[Inp] properties
                                                Bk::IViewersEnumerator *i_pEnum     //[Inp] viewers enumerator
                                               );
#endif //BK_API_VIEWER_H