////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <list>

#include "GTypes.h"
#include "PSocket.h"
#include "Length.h"
#include "PString.h"
#include "Prop.h"
#include "Lock.h"
#include "IMEvent.h"
#include "Length.h"
#include "PMEvent.h"
#include "PThreadShell.h"
#include "P7_Client.h"
#include "P7_Telemetry.h"
#include "P7_Trace.h"
#include "P7_Extensions.h"

#include "PAPI.h"
#include "PAPI_Node.h"
#include "PAPI_Plugins.h"
#include "PAPI_Provider.h"
#include "PAPI_Storage.h"
#include "PAPI_Storage_Telemetry.h"
#include "PAPI_Storage_Trace.h"
#include "PAPI_Processor.h"

#include "Stream.h"
#include "Trace.h"
#include "Telemetry.h"
#include "Processor.h"

static const GUID g_sPlugin_GUID = { 0x8dab8e20, 0x815b, 0x4d67, { 0x90, 0x46, 0xe8, 0xfe, 0xfc, 0xfb, 0x3e, 0x34 } };

extern "C" 
{
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/// <summary>Provides plugin information</summary>
/// <param name="o_pInfo"> plugin information, output value</param>
/// <returns>Bk::eResult __stdcall</returns>
P7_EXPORT Bk::eResult __cdecl Get_Plugin_Info(Bk::stPluginInfo *o_pInfo)
{
    Bk::eResult eResult = Bk::eOk;

    if (NULL == o_pInfo)
    {
        return Bk::eErrorWrongInput;
    }

    memcpy(&o_pInfo->sGUID, &g_sPlugin_GUID, sizeof(GUID));

    o_pInfo->eType         = Bk::ePluginStreamsProcessor;
    o_pInfo->dwAPI_Version = BK_PLUGIN_API_VERSION;
    o_pInfo->qwVersion     = 0;
    o_pInfo->pFormats      = NULL;

    PStrCpy(o_pInfo->pName, LENGTH(o_pInfo->pName), TM("Processor: Base"));

    return eResult;
}//Get_Plugin_Info

//compiler check than function match the prototype
static const fnBkGetPluginInfo g_pGetPluginInfo = Get_Plugin_Info;


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/// <summary>Create dispatcher class instance</summary>
/// <param name="i_pBaikal"> Baikal main interface</param>
/// <param name="i_pNode"> Confoguration node of dispatcher plugin</param>
/// <param name="o_rDispatcher"> resulting dispatcher interface</param>
/// <returns>Bk::eResult::eOk in case of success</returns>
/// <remarks></remarks>
P7_EXPORT Bk::eResult __cdecl Create_Processor(Bk::IUnknown    *i_pBaikal,     //[inp] Baikal interface
                                               Bk::IBNode      *i_pNode,       //[inp] Dispatcher config. node
                                               CProperty       *i_pProp,       //[Inp] properties
                                               Bk::IProcessor *&o_rProcessor   //[out] Processor interface
                                              )
{
    o_rProcessor = new CProcessor(i_pBaikal, i_pNode, i_pProp);
    return Bk::eOk;
}


//compiler check than function match the prototype
static const fnBkCreateProcessor g_pCreateProcessor = Create_Processor;
}//extern "C"


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//Dll entry point
#if defined(_WIN32) || defined(_WIN64)
    BOOL APIENTRY DllMain(HMODULE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
    {
        switch (ul_reason_for_call)
        {
            case DLL_PROCESS_ATTACH:
            case DLL_THREAD_ATTACH:
            case DLL_THREAD_DETACH:
            case DLL_PROCESS_DETACH:
            {
                break;
            }
        }
        return TRUE;
    }
#endif
