////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2019 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_P7_COMMON_H
#define BK_P7_COMMON_H

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "GTypes.h"

#include "Length.h"
#include "PProfiler.h"
#include "PString.h"
#include "WString.h"
#include "UTF.h"

#include "PAtomic.h"
#include "PLock.h"
#include "PSocket.h"
#include "IMEvent.h"
#include "PMEvent.h"
#include "AList.h"
#include "PFileSystem.h"
#include "RBTree.h"
#include "Prop.h"
#include "IMEvent.h"
#include "PMEvent.h"
#include "PThreadShell.h"
#include "PTime.h"
#include "IFile.h"
#include "PFile.h"

#include "P7_Client.h"
#include "P7_Telemetry.h"
#include "P7_Trace.h"
#include "P7_Extensions.h"

#include "Formatter.h"

#include "PAPI.h"
#include "PAPI_Node.h"
#include "PAPI_Plugins.h"
#include "PAPI_Provider.h"
#include "PAPI_Storage.h"
#include "PAPI_Storage_Trace.h"
#include "P7Trace.h"


#if !defined(BK_LOGGER)
    #define BK_LOGGER m_iP7_Trace
#endif

#if !defined(BK_LOG_MODULE)
    #define BK_LOG_MODULE m_hP7_TraceModule
#endif

#if !defined(BK_TELEMETRY)
    #define BK_TELEMETRY m_iP7_Tel
#endif


#define LOG_TRACE(...) if (BK_LOGGER) (BK_LOGGER)->P7_TRACE(BK_LOG_MODULE,    __VA_ARGS__);
#define LOG_DEBUG(...) if (BK_LOGGER) (BK_LOGGER)->P7_DEBUG(BK_LOG_MODULE,    __VA_ARGS__);
#define LOG_INFO(...) if (BK_LOGGER) (BK_LOGGER)->P7_INFO(BK_LOG_MODULE,     __VA_ARGS__);
#define LOG_WARNING(...) if (BK_LOGGER) (BK_LOGGER)->P7_WARNING(BK_LOG_MODULE,  __VA_ARGS__);
#define LOG_ERROR(...) if (BK_LOGGER) (BK_LOGGER)->P7_ERROR(BK_LOG_MODULE,    __VA_ARGS__);
#define LOG_CRITICAL(...) if (BK_LOGGER) (BK_LOGGER)->P7_CRITICAL(BK_LOG_MODULE, __VA_ARGS__);

#define TEL_ADD(i_bCId, i_llValue) if (BK_TELEMETRY) (BK_TELEMETRY)->Add(i_bCId, i_llValue);
#endif //BK_P7_COMMON_H