#ifndef HEADER_PUGIHLP_HPP
#define HEADER_PUGIHLP_HPP

class CPugiHLP
{
public:
    ////////////////////////////////////////////////////////////////////////////////
    //Get_Node
    static BOOL Get_Node(pugi::xml_node  i_cNode, 
                         wchar_t        *i_pPath, 
                         pugi::xml_node *o_pNode
                        )
    {
        wchar_t *l_pNext = i_pPath;
        DWORD    l_dwLen = 0;
        BOOL     l_bExit = FALSE;
        BOOL     l_bFind = FALSE;

        if (    (NULL == i_pPath)
             || (NULL == o_pNode)
           )
        {
            return NULL;
        }


        while (FALSE == l_bExit)
        {
            while (    (L'/' != *l_pNext)
                    && (0    != *l_pNext)
                  )
            {
                l_pNext ++;
            }

            l_bFind = FALSE;
            while (FALSE == l_bFind)
            {
                if (true == i_cNode.empty())
                {
                    break;
                }
                else if (    ( pugi::node_element == i_cNode.type() ) 
                          && ( 0 == _wcsnicmp(i_pPath, i_cNode.name(), l_pNext - i_pPath) )
                        )
                {
                    l_bFind = TRUE;
                }
                else
                {
                    i_cNode = i_cNode.next_sibling();
                }
            }

            if (0 == *l_pNext)
            {
                l_bExit = TRUE;
            }
            else //if (L'/' == *l_pNext)
            {
                i_pPath = ++l_pNext;
                i_cNode = i_cNode.first_child();
            }
        }

        if (l_bFind)
        {
            *o_pNode = i_cNode;
        }

        return l_bFind;
    }//Get_Node


    ////////////////////////////////////////////////////////////////////////////////
    //Get_Node_Next
    static BOOL Get_Node_Next(pugi::xml_node  i_cNode, 
                              wchar_t        *i_pName,
                              pugi::xml_node *o_pNode
                             )
    {
        if (    (NULL == o_pNode) 
             || (NULL == i_pName) 
           )
        {
            return NULL;
        }

        pugi::xml_node  l_cNext = i_cNode.next_sibling();
        BOOL            l_bExit = FALSE;
        BOOL            l_bFind = FALSE;

        while (FALSE == l_bExit)
        {
            if (true == l_cNext.empty())
            {
                l_bExit = TRUE;
            }
            else if (    ( pugi::node_element == l_cNext.type() )
                      && ( 0 == _wcsicmp(i_pName, l_cNext.name()) )
                    )
            {
                *o_pNode = l_cNext;
                l_bFind  = TRUE;
                l_bExit  = TRUE;
            }
            else
            {
                l_cNext = l_cNext.next_sibling();
            }
        }

        return l_bFind;
    }//Get_Node_Next


    ////////////////////////////////////////////////////////////////////////////////
    //Get_Attr
    static wchar_t *Get_Attr(pugi::xml_node i_cNode, wchar_t *i_pName)
    {
        BOOL     l_bExit   = FALSE;
        wchar_t *l_pReturn = NULL;

        if (NULL == i_pName)
        {
            return NULL;
        }

        pugi::xml_attribute l_cPX_Attribute = i_cNode.first_attribute();

        while (FALSE == l_bExit)
        {
            if ( l_cPX_Attribute.empty() )
            {
                l_bExit = TRUE;
            }
            else if ( 0 == _wcsicmp(i_pName, l_cPX_Attribute.name()) )
            {
                l_pReturn = (wchar_t*)l_cPX_Attribute.value();
                l_bExit = TRUE;
            }
            else
            {
                l_cPX_Attribute = l_cPX_Attribute.next_attribute();
            }
        }

        return l_pReturn;
    }//Get_Attr
};

#endif //HEADER_PUGIHLP_HPP
