////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2020 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef P7_SADDR_H
#define P7_SADDR_H

class CSAddress
    : public IP7S_Address
{
    //put volatile variables at the top, to obtain 32 bit alignment. 
    //Project has 8 bytes alignment by default
    tINT32 volatile        m_lBytesIn;
    tINT32 volatile        m_lBytesOut;

    eServer_Status         m_eStatus;
    CUDP_Socket           *m_pSocket;
    IJournal              *m_pLog;
    IJournal::hModule      m_hLogMod;
    CBList<CSConnection*> *m_pConnections;
    CBList<CSConnection*> *m_pConnections_New;
    CBList<CSConnection*> *m_pConnections_Active;
    CBuffers_Pools        *m_pBPool;
    tUINT32                m_dwID;
    tUINT32                m_dwConn_ID;        
    tLOCK                  m_tCS;   
    CMEvent                m_cDel_Event; 
    CMEvent                m_cExit_Event; 
    CThShell::tTHREAD      m_hThread;
    tBOOL                  m_bIsThread;
    CSConnection          *m_pDel_Connection;

    pAList_Cell            m_pList_Cell;
public:
    CSAddress(IJournal         *i_pLog, 
              CBuffers_Pools   *i_pBPool,
              sockaddr_storage *i_pAddress,
              tUINT32           i_dwID);

    virtual ~CSAddress();

    eServer_Status    Get_Status();
    sockaddr_storage *Get_Socket_Address();
    tBOOL             Get_Stat(tUINT32 &o_rBytesIn, tUINT32 &o_rBytesOut);


    IP7S_Connnection *Get_Next_Conn(IP7S_Connnection *i_pConn);
    IP7S_Connnection *Get_New_Conn();
    tBOOL             Del_Conn(IP7S_Connnection *i_pConn);

    void              Set_Cell(pAList_Cell i_pCell);
    pAList_Cell       Get_Cell();

protected:
    CSConnection     *Add_Conn(sockaddr_storage *i_pAddress, tBOOL i_bBigEndian, tINT32 i_iSocketBufferSize);

    void              Print_Connections();

    static THSHELL_RET_TYPE THSHELL_CALL_TYPE Static_Routine(void *i_pContext)
    {
        CSAddress *l_pRoutine = static_cast<CSAddress *>(i_pContext);
        if (l_pRoutine)
        {
            l_pRoutine->Routine();
        }

        CThShell::Cleanup();
        return THSHELL_RET_OK;
    } 

    virtual void      Routine();
};

#endif //P7_SADDR_H
