////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2020 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_API_CORE_H
#define BK_API_CORE_H

#include "PAPI.h"
#include "PAPI_Node.h"
#include "PAPI_Provider.h"
#include "PAPI_Storage.h"

namespace Bk
{
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// <summary>Core interface</summary>
    class ICore
        : public Bk::IUnknown
    {
    public:
        /// <summary> Create base storage for stream </summary>
        /// <param name="i_pInfo"> stream info </param>
        /// <param name="o_rStorage"> storage instance, output paramter </param>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        virtual Bk::eResult __stdcall Create_Storage(Bk::stStreamInfo *i_pInfo, Bk::IStorage *&o_rStorage) = 0;

        /// <summary> Register new stream when it was initialized by provider </summary>
        /// <param name="i_pStreamId"> strean ID </param>
        /// <param name="i_iReader"> storage reader </param>
        /// <param name="i_iEx"> stream extra interface </param>
        /// <returns>Bk::eResult::eOk in case of success</returns>  
        virtual Bk::eResult __stdcall Register_New_Stream(const void         *i_pStreamId,
                                                          Bk::IStorageReader *i_iReader,
                                                          Bk::IStreamEx      *i_iEx) = 0;
    };
}

#endif //BK_API_CORE_H