////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2020 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_STREAM_H
#define BK_STREAM_H

#define SAFE_RELEASE(x) if (x) { x->Release(); x = NULL;}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/// <summary> Base stream abstract class </summary>
class CStream
{
protected:
    Bk::IStorageReader *m_iReader; //storage reader interface
    Bk::IStreamEx *m_iExtra; //extra stream interface, used to check Online streams state
    Bk::stStorageInfo m_stInfo; //storage base information
    tUINT64 m_qwTime; //stream time

public:
    enum eResult
    {
        eProcessing,
        eIdling,
        eDone
    };

    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    CStream(Bk::IStorageReader *i_iReader, Bk::IStreamEx *i_iExtra)
        : m_iReader(i_iReader)
        , m_iExtra(i_iExtra)
    {
        //getting storage info
        if (Bk::eOk == m_iReader->Get_Info(&m_stInfo))
        {
            //getting stream time in 100ns intervals, will be used later to format trace/telemetry time
            m_qwTime = (tUINT64)m_stInfo.sStream_Time.dwLowDateTime + (((tUINT64)m_stInfo.sStream_Time.dwHighDateTime) << 32);
        }
    }

    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    virtual ~CStream()
    {
        SAFE_RELEASE(m_iReader);
        SAFE_RELEASE(m_iExtra);
    }

    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    virtual CStream::eResult Process() = 0;
};

#endif //BK_STREAM_H