////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2020 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#pragma once


////////////////////////////////////////////////////////////////////////////////
//CP7Stream_Ex
class  CP7Stream_Ex: 
    public Bk::IStreamEx
{
protected:
    //put volatile variables at the top, to obtain 32 bit alignment. 
    //Project has 8 bytes alignment by default
    tINT32 volatile m_lReference;

    tBOOL           m_bActive;
    CP7Importer    *m_iProvider;
    CLock           m_cLock;
public:
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    CP7Stream_Ex(CP7Importer *i_iProvider)
        : m_lReference(1)
        , m_bActive(TRUE)
        , m_iProvider(i_iProvider)
    {
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    virtual ~CP7Stream_Ex()
    {
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Bk::eResult __stdcall Initialize(const tXCHAR *i_pSession)
    {
        UNUSED_ARG(i_pSession);
        return Bk::eOk;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Bk::eResult __stdcall Close()
    {
        return Bk::eOk;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Bk::eResult __stdcall Is_Active(tBOOL *o_pActive)
    {
        CLock l_cLock(&m_cLock);
        if (o_pActive)
        {
            *o_pActive = m_bActive;
        }
        return Bk::eOk;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Bk::eResult __stdcall Get_Status(Bk::stStreamStatus *o_pStatus)
    {
        CLock l_cLock(&m_cLock);

        if (    (m_bActive)
             && (m_iProvider)
           )
        {
            o_pStatus->eConnection = Bk::eStreamConOnline;
            o_pStatus->dwDown_Time = 0;
        }
        else
        {
            o_pStatus->eConnection = Bk::eStreamConClosed;
            o_pStatus->dwDown_Time = 0xFFFFFFFF;
        }

        return Bk::eOk;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Bk::eResult __stdcall Get_Root(CProperty *&o_rRoot)
    {
        CLock l_cLock(&m_cLock);
        o_rRoot = NULL;

        return Bk::eOk;
    }//CP7Stream_Ex::Get_Root()

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    void Deactivate()
    {
        CLock l_cLock(&m_cLock);
        m_bActive     = FALSE;
        m_iProvider   = NULL;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    tINT32 __stdcall Add_Ref()
    {
        return ATOMIC_INC(&m_lReference);
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    tINT32 __stdcall Release()
    {
        tINT32 l_lResult = ATOMIC_DEC(&m_lReference);
        if ( 0 >= l_lResult )
        {
            delete this;
        }

        return l_lResult;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Bk::eResult __stdcall Query_Interface(Bk::eInterface i_eId, void *&o_rUnknown)
    {
        UNUSED_ARG(i_eId);

        o_rUnknown = NULL;
        return Bk::eErrorNotImplemented;
    }
};//CP7Stream_Op
