////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2020 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#pragma once

////////////////////////////////////////////////////////////////////////////////
class CJrTrProxy 
    : public IJournal
{
    IP7_Trace       *m_iTrace;
    IJournal::eLevel m_eVerbosity;
public:  
    ////////////////////////////////////////////////////////////////////////////
    CJrTrProxy(IP7_Trace *i_iTrace)
        : m_iTrace(i_iTrace)
        , m_eVerbosity(IJournal::eLEVEL_CRITICAL)
    { 
        if (m_iTrace) 
        {
            m_iTrace->Add_Ref();
        }
    }

    ////////////////////////////////////////////////////////////////////////////
    virtual ~CJrTrProxy()
    { 
        if (m_iTrace) 
        {
            m_iTrace->Release(); 
            m_iTrace = NULL;
        }
    }

    ////////////////////////////////////////////////////////////////////////////
    tBOOL Initialize(const tXCHAR *i_pName)
    { 
        UNUSED_ARG(i_pName);
        return TRUE;
    }

    ////////////////////////////////////////////////////////////////////////////
    void Set_Verbosity(IJournal::eLevel i_eVerbosity)
    { 
        if (m_iTrace) 
        {
            m_iTrace->Set_Verbosity(NULL, (eP7Trace_Level)i_eVerbosity);
        }
        m_eVerbosity = i_eVerbosity;
    }

    ////////////////////////////////////////////////////////////////////////////
    IJournal::eLevel Get_Verbosity() { return m_eVerbosity; }

    ////////////////////////////////////////////////////////////////////////////
    tBOOL Register_Thread(const tXCHAR *i_pName, tUINT32 i_dwThreadId)
    {
        if (m_iTrace) 
        {
            return m_iTrace->Register_Thread(i_pName, i_dwThreadId);
        }
        return FALSE;
    }

    ////////////////////////////////////////////////////////////////////////////
    tBOOL Unregister_Thread(tUINT32 i_dwThreadId)        
    {
        if (m_iTrace) 
        {
            return m_iTrace->Unregister_Thread(i_dwThreadId);
        }
        return FALSE;
    }

    ////////////////////////////////////////////////////////////////////////////
    tBOOL Register_Module(const tXCHAR *i_pName, IJournal::hModule *o_hModule)                               
    {
        if (m_iTrace) 
        {
            return m_iTrace->Register_Module(i_pName, o_hModule);
        }

        return FALSE;
    }

    ////////////////////////////////////////////////////////////////////////////
    tBOOL Log(IJournal::eLevel  i_eType, 
              IJournal::hModule i_hModule,
              const char       *i_pFile,
              const char       *i_pFunction, 
              tUINT32           i_dwLine,
              const tXCHAR     *i_pFormat, 
              ...
             )     
    {
        tBOOL l_bReturn = FALSE;
        if (m_iTrace) 
        {
            va_list l_pVl;
            va_start(l_pVl, i_pFormat);

            l_bReturn = m_iTrace->Trace_Embedded(0,
                                                 (eP7Trace_Level)i_eType, 
                                                 i_hModule, 
                                                 (tUINT16)i_dwLine, 
                                                 i_pFile, 
                                                 i_pFunction, 
                                                 &i_pFormat,
                                                 &l_pVl
                                                );

            va_end(l_pVl);
        }

        return l_bReturn;
    }

    ////////////////////////////////////////////////////////////////////////////
    tUINT64 Get_Count(IJournal::eLevel i_eType)
    {
        UNUSED_ARG(i_eType);
        return 0ull;
    }

    ////////////////////////////////////////////////////////////////////////////
    tINT32 Add_Ref()                                      
    {
        if (m_iTrace) 
        {
            return m_iTrace->Add_Ref();
        }

        return 1;
    }

    ////////////////////////////////////////////////////////////////////////////
    tINT32 Release()                                      
    {
        if (m_iTrace) 
        {
            return m_iTrace->Release();
        }

        return 1;
    }
};
