////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2020 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_P7_TELEMETRY_TYPES_H
#define BK_P7_TELEMETRY_TYPES_H

#define HEADER_ASSERT(cond) typedef int assert_type[(cond) ? 1 : -1]


//10110111011110111110111111011111110111111110111111111011111111b
#define FILE_HEADER_MARKER                               (0x2DDEFBF7F7FBFEFFULL) 
#define FILE_HEADER_VERSION                              (0x0001) 
#define MAX_STREAM_NAME_LENGTH                           64

PRAGMA_PACK_ENTER(1)

struct sCounter
{
    tUINT8   bOn;
    tUINT8   bInitialized;
    tINT64   llMin;
    tINT64   llMin_Real;
    tINT64   llMax;
    tINT64   llMax_Real;
    tINT64   llAlarm;
    tDOUBLE  dbCumulative;
    tUINT64  qwSamples;
    tWCHAR   pName[P7TELEMETRY_COUNTER_NAME_LENGTH_V1];
} ATTR_PACK(1);

struct sFile_Header
{
    tUINT64  qwMarker;
    tUINT16  wHeader_Version;

    //http://msdn.microsoft.com/en-us/library/windows/desktop/ms738531(v=vs.85).aspx
    tWCHAR   pNode_Name[MAX_NODE_NAME_LENGTH];
    tUINT16  wProtocol_Version;
    tUINT32  dwProcess_ID;
    FILETIME sProcess_Time;
    tWCHAR   pProcess_Name[MAX_PROCESS_NAME_LENGTH];

    FILETIME sStream_Time;
    tUINT64  qwDuration; //in Hi resolution timer ticks
    //Hi resolution timer value, we get this value when we retrieve current time.
    //using difference between this value and timer value for every sample we can
    //calculate time of the sample event with hi resolution
    tUINT64  qwTimer_Value;
    //timer's count heartbeats in second                       
    tUINT64  qwTimer_Frequency;                               
    tWCHAR   pStream_Name[MAX_STREAM_NAME_LENGTH];                 

    tUINT64  qwSamples_Count;
    tUINT8   bCounters_Number;
    sCounter pCounters[P7TELEMETRY_COUNTERS_MAX_COUNT_V1]; 
} ATTR_PACK(1);

////////////////////////////////////////////////////////////////////////////////
//Index file [sMap_Index], [sMap_Index], .... [sMap_Index]
struct sIndex_Header
{
    tUINT64  qwFirst_IDX; 
    tUINT64  qwCount; 
} ATTR_PACK(1);

//Map file [sMap_Header], [sIndex_Item], .... [sIndex_Item]
struct sIndex_Item
{
    tUINT64 qwSample_IDX; //MAXUINT64 - undefined value;
} ATTR_PACK(1);

PRAGMA_PACK_EXIT()

#endif //BK_P7_TELEMETRY_TYPES_H