////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2020 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef BK_P7_TELEMETRY_TYPES_V2_H
#define BK_P7_TELEMETRY_TYPES_V2_H

#define HEADER_ASSERT(cond) typedef int assert_type[(cond) ? 1 : -1]

#define FILE_HEADER_MARKER                               (0xF9DE30BAC93A4E0DULL) 
#define FILE_HEADER_VERSION_V1                           (0x0001) 
#define FILE_HEADER_VERSION_V2                           (0x0002) 
#define MAX_STREAM_NAME_LENGTH                           64

#define FILE_HEADER_FLAG_TRACE_EXTENSION                 (0x1)
#define FILE_HEADER_FLAG_TRACE_TIME_ZONE                 (0x2)

#define FILE_EXTRA_TIMEZONE                               1ull

#define FILE_PACK_SIZE                                    4

#define FILE_INDEX_EXTENSION                              TM(".p7i")

PRAGMA_PACK_ENTER(FILE_PACK_SIZE)
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
struct sCounter
{
    tUINT32  uSize; 
    tUINT32  uId; 
    tBOOL    bOn;
    tBOOL    bInitialized;
    tDOUBLE  dbMin;
    tDOUBLE  dbMin_Real;
    tDOUBLE  dbMin_Alarm;
    tDOUBLE  dbMax;
    tDOUBLE  dbMax_Real;
    tDOUBLE  dbMax_Alarm;
    tDOUBLE  dbCumulative;
    tUINT64  qwSamples;
    tWCHAR   pName[1];
} ATTR_PACK(FILE_PACK_SIZE);


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
struct sFile_Header
{
    tUINT64  qwMarker;
    tUINT16  wHeader_Version;

    //http://msdn.microsoft.com/en-us/library/windows/desktop/ms738531(v=vs.85).aspx
    tWCHAR   pNode_Name[MAX_NODE_NAME_LENGTH];
    tUINT16  wProtocol_Version;  ATTR_ALIGN(FILE_PACK_SIZE) //Fix GCC aligment issue
    tUINT32  dwProcess_ID;
    FILETIME sProcess_Time;
    tWCHAR   pProcess_Name[MAX_PROCESS_NAME_LENGTH];

    FILETIME sStream_Time;
    tUINT64  qwDuration; //in Hi resolution timer ticks
    //Hi resolution timer value, we get this value when we retrieve current time.
    //using difference between this value and timer value for every sample we can
    //calculate time of the sample event with hi resolution
    tUINT64  qwTimer_Value;
    //timer's count heartbeats in second                       
    tUINT64  qwTimer_Frequency;                               
    tWCHAR   pStream_Name[MAX_STREAM_NAME_LENGTH];                 

    tUINT64  qwSamples_Count;
} ATTR_PACK(FILE_PACK_SIZE);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
struct sFile_Extra
{
    tUINT64  qwFlags; 
    tINT32   iUtcOffsetSec;
    tUINT64  qwCountersSectionSize;  
    tUINT64  qwCountersSectionOffset;
    tUINT8   pBuffer[1024]; //buffer for further needs
} ATTR_PACK(FILE_PACK_SIZE);


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Index file [sMap_Index], [sMap_Index], .... [sMap_Index]
struct sIndex_Header
{
    tUINT64  qwFirst_IDX; 
    tUINT64  qwCount; 
} ATTR_PACK(FILE_PACK_SIZE);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Map file [sMap_Header], [sIndex_Item], .... [sIndex_Item]
struct sIndex_Item
{
    tUINT64 qwSample_IDX; //MAXUINT64 - undefined value;
} ATTR_PACK(FILE_PACK_SIZE);

struct sExtra_Header
{
    tUINT64   qwMarker;
    tUINT64   qwSize;
    tUINT32   dwType; 
    tUINT32   dwCount;
} ATTR_PACK(FILE_PACK_SIZE);

PRAGMA_PACK_EXIT()
#endif //BK_P7_TELEMETRY_TYPES_V2_H
