////////////////////////////////////////////////////////////////////////////////
//                                                                             /
// 2012-2021 (c) Baical                                                        /
//                                                                             /
// This library is free software; you can redistribute it and/or               /
// modify it under the terms of the GNU Lesser General Public                  /
// License as published by the Free Software Foundation; either                /
// version 3.0 of the License, or (at your option) any later version.          /
//                                                                             /
// This library is distributed in the hope that it will be useful,             /
// but WITHOUT ANY WARRANTY; without even the implied warranty of              /
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           /
// Lesser General Public License for more details.                             /
//                                                                             /
// You should have received a copy of the GNU Lesser General Public            /
// License along with this library.                                            /
//                                                                             /
////////////////////////////////////////////////////////////////////////////////
#ifndef UP7_CONTEXT_H
#define UP7_CONTEXT_H

#define UP7_TAIL    16
#define UP7_CONTROL 16

struct stuP7context                                    
{
    bool                    bInitialized;         /**< initialized flag */
    uint32_t                uSessionId;           /**< Session ID*/  
    uint8_t                 bCpuId;               /**< cpu id */
    void                   *pCtxTimer;            /**< Context for timer functions */
    fnuP7getTimerFrequency  cbTimerFrequency;     /**< callback to get system high-resolution timer frequency */
    fnuP7getTimerValue      cbTimerValue;         /**< callback to get system high-resolution timer value */
                                                  
    void                   *pCtxLock;             /**< Context for lock functions, set it to NULL if there is no RTOS*/
    fnuP7lock               cbLock;               /**< callback to call OS lock function, set it to NULL if there is no RTOS */
    fnuP7unlock             cbUnLock;             /**< callback to call OS unlock function, set it to NULL if there is no RTOS */
                                                  
    void                   *pCtxPacket;           /**< Context for data sending (cbSendPacket function) */
    fnuP7sendPacket         cbSendPacket;         /**< callback to send data packet to host */  

    void                   *pCtxThread;           /**< Context for cbGetCurrentThreadId function */
    fnuP7getCurrentThreadId cbGetCurrentThreadId; /**< callback get current thread ID, set it to NULL if there is no RTOS*/  

    enum euP7Level          eDefaultVerbosity;    /**< Default verbosity*/  

    uint32_t                uTrcCounter;          /**< Trace items counter*/  

    uint64_t                qwCreationTime;       /**< Creation time*/  

    struct stP7packetChunk  stTelChunk[2];        /**< Cached telemetry sample chunk*/  
    size_t                  szTelChunks;          /**< telemetry chunks count*/  
    stuP7telHdr             stTelSample;          /**< Cached telemetry sample value*/

    struct stuP7Module     *pModules;             /**< Trace modules descriptors, generated by uP7 preprocessor*/  
    size_t                  szModules;            /**< Trace modules descriptors count*/  

    struct stuP7Trace      *pTraces;              /**< Trace descriptors, generated by uP7 preprocessor*/  
    size_t                  szTraces;             /**< Trace descriptors count*/  
    bool                    bTraceDirect;         /**< Is it possible to access trace descriptor by ID direcly*/  

    struct stuP7telemetry  *pTelemetry;           /**< Telemetry descriptors, generated by uP7 preprocessor*/  
    size_t                  szTelemetry;          /**< Telemetry descriptors count*/  

    size_t                  szAlignmentMask;      /**< transport packet size alignment mask*/      
    size_t                  szAlignment;          /**< transport packet size alignment mask*/      
    uint8_t                 pTail[UP7_TAIL];      /**< Packet tail*/  

    uint8_t                 pControl[UP7_CONTROL];/**< Control packet*/  
    size_t                  szControl;            /**< Size of control packet head*/  
};

#endif //UP7_CONTEXT_H
